PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144772102"
 Author = "jayas.jayas"
 Desc = "Parallel Transmission Lines using Mutual Coupling"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 495
  Debug = 0
  StartFile = ""
  OFile = "case3_Mutual.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([54,36],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,702,1152]
    Posn = [54,36]
    Icon = [-1,-1]
    Extents = 0,0,702,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,702,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(28226040,"V1a",8388608,,,)
     Curve(28042120,"V1b",32768,,,)
     Curve(28023080,"V1c",128,,,)
     }
    Graph([0,277],[0,0,702,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(28097352,"I1a",8388608,,,)
     Curve(28113568,"I1b",32768,,,)
     Curve(28100152,"I1c",128,,,)
     }
    Graph([0,554],[0,0,702,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(28103904,"I10",8388608,,,)
     }
    PGraph([0,831],[0,0,702,258],"PolyGraph")
     {
     Options = 2
     Curve(28031456,"Br1a",8388608,,,1)
     Curve(28044896,"Br1b",32768,,,1)
     Curve(28086520,"Br1c",128,,,1)
     }
    }
   -Plot-([810,36],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,702,1152]
    Posn = [810,36]
    Icon = [-1,-1]
    Extents = 0,0,702,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,702,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(28160448,"V3a",8388608,,,)
     Curve(28163224,"V3b",32768,,,)
     Curve(28166304,"V3c",128,,,)
     }
    Graph([0,277],[0,0,702,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(28169216,"I3a",8388608,,,)
     Curve(28172128,"I3b",32768,,,)
     Curve(28175040,"I3c",128,,,)
     }
    Graph([0,554],[0,0,702,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(28177928,"I30",8388608,,,)
     }
    PGraph([0,831],[0,0,702,258],"PolyGraph")
     {
     Options = 2
     Curve(28198776,"Br3a",8388608,,,1)
     Curve(28201552,"Br3b",32768,,,1)
     Curve(28204328,"Br3c",128,,,1)
     }
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,702,1170]
    Posn = [18,18]
    Icon = [-1,-1]
    Extents = 0,0,702,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,702,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(28025992,"V2a",8388608,,,)
     Curve(28351552,"V2b",32768,,,)
     Curve(28055824,"V2c",128,,,)
     }
    Graph([0,282],[0,0,702,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(28017400,"I2a",8388608,,,)
     Curve(28020232,"I2b",32768,,,)
     Curve(28110656,"I2c",128,,,)
     }
    Graph([0,563],[0,0,702,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(28107880,"I20",8388608,,,)
     }
    PGraph([0,844],[0,0,702,263],"PolyGraph")
     {
     Options = 2
     Curve(28035808,"Br2a",8388608,,,1)
     Curve(28047672,"Br2b",32768,,,1)
     Curve(28038448,"Br2c",128,,,1)
     }
    }
   -Plot-([846,18],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,702,1170]
    Posn = [846,18]
    Icon = [-1,-1]
    Extents = 0,0,702,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,702,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(28180840,"V4a",8388608,,,)
     Curve(28183928,"V4b",32768,,,)
     Curve(28348584,"V4c",128,,,)
     }
    Graph([0,282],[0,0,702,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(28186840,"I4a",8388608,,,)
     Curve(28189752,"I4b",32768,,,)
     Curve(28192840,"I4c",128,,,)
     }
    Graph([0,563],[0,0,702,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(28195864,"I40",8388608,,,)
     }
    PGraph([0,844],[0,0,702,263],"PolyGraph")
     {
     Options = 2
     Curve(27959440,"Br4a",8388608,,,1)
     Curve(28215840,"Br4b",32768,,,1)
     Curve(28218616,"Br4c",128,,,1)
     }
    }
   }
  }
 Module("Controls")
  {
  Desc = ""
  FileDate = 1144771850
  Nodes = 
   {
   Output("F",36,18)
    {
    Type = Integer
    }
   Output("B",36,-36)
    {
    Type = Integer
    Dim  = [4]
    }
   Input("Flt_en",36,-18)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Line(34,-18,27,-18)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   -Sticky-([72,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 72,666,180,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   0.export([1494,1152],4,0,300)
    {
    Name = "F"
    }
   -Wire-([684,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([720,648],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([720,684],0,0,-1)
    {
    Name = "Tfd"
    }
   0.datalabel([846,666],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1404,1152],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1404,1152],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(28296336)
    Meter(28338336)
    Slider(28289552)
    Meter(28231920)
    Meter(28064136)
    Meter(28091456)
    Meter(28210016)
    Meter(28212928)
    }
   -Sticky-([558,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 558,108,738,180
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   -ControlPanel-([72,720],0)
    {
    Name = "Fault Location, Type, Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,432,126
    Dial(28243184)
    Dial(28275256)
    Slider(27926944)
    Slider(27929928)
    Slider(28356000)
    }
   0.datalabel([1602,702],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1602,756],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1602,810],3,0,-1)
    {
    Name = "B4T1"
    }
   0.datalabel([1404,1008],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1404,1026],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1404,1044],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1404,1062],6,0,-1)
    {
    Name = "B4"
    }
   0.datamerge([1422,1080],4,0,290)
    {
    N = "4"
    Type = "1"
    Disp = "1"
    }
   0.export([1458,1098],4,0,310)
    {
    Name = "B"
    }
   -Wire-([684,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -ControlPanel-([1296,270],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(27861960)
    Slider(27879760)
    Slider(27873288)
    }
   -ControlPanel-([1296,414],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(27865864)
    Slider(27876008)
    Slider(27917936)
    }
   0.datalabel([1602,864],3,0,-1)
    {
    Name = "B4T2"
    }
   -ControlPanel-([1296,648],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(27887432)
    Slider(27892816)
    Slider(27819016)
    }
   -ControlPanel-([1296,792],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Switch(27895720)
    Slider(27816160)
    Slider(27813008)
    }
   0.var([1566,864],0,27813008,160)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1566,810],0,27816160,140)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   0.var([1566,756],0,27819016,120)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.tfaultn([810,666],4,0,230)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -Sticky-([18,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,198,162,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(28283712)
    Meter(28332400)
    Slider(28286696)
    Meter(28229008)
    Meter(28237776)
    Meter(28094440)
    Meter(28280296)
    Meter(28207104)
    }
   -Wire-([1872,468],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1872,288],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([1908,468],6,0,220)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([1908,288],0,0,200)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1944,288],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1944,252],0,27861960,10)
    {
    Name = "42-B1"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.datalabel([2052,288],4,0,-1)
    {
    Name = "B1"
    }
   -Wire-([1944,468],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1944,414],6,27865864,50)
    {
    Name = "42-B2"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1980,432],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([2052,432],2,0,-1)
    {
    Name = "B2"
    }
   0.tbreakn([1818,288],4,0,190)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.datalabel([1602,324],3,0,-1)
    {
    Name = "B1T1"
    }
   0.datalabel([1602,378],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1602,432],3,0,-1)
    {
    Name = "B2T1"
    }
   0.var([1566,378],0,27873288,30)
    {
    Name = "B1 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1566,432],0,27876008,40)
    {
    Name = "B2 T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1602,486],3,0,-1)
    {
    Name = "B2T2"
    }
   0.var([1566,324],0,27879760,20)
    {
    Name = "B1 T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([1746,216],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1746,216,1926,252
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   0.logic([2016,288],6,0,210)
    {
    Type = "2"
    Inv = "0"
    }
   -Wire-([1872,864],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1872,684],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([1872,720],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   0.logic([1908,864],6,0,180)
    {
    Type = "1"
    Inv = "0"
    }
   0.logic([1908,684],0,0,250)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1944,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var_switch([1944,648],0,27887432,100)
    {
    Name = "42-B3"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   -Wire-([1944,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1980,828],0,0,-1)
    {
    Vertex="0,0;0,-18"
    }
   0.datalabel([2052,684],4,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([2052,828],2,0,-1)
    {
    Name = "B4"
    }
   0.var([1566,702],0,27892816,110)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   0.var_switch([1944,810],6,27895720,150)
    {
    Name = "42-B4"
    Group = ""
    Display = "0"
    Value = "0"
    Max = "1"
    Min = "0"
    Ton = "O"
    Toff = "C"
    }
   0.tbreakn([1818,864],4,0,170)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.logic([2016,684],6,0,260)
    {
    Type = "2"
    Inv = "0"
    }
   -ControlPanel-([936,180],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(28390464)
    Slider(28380888)
    }
   0.var([1566,486],0,27917936,60)
    {
    Name = "B2 T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.tbreakn([1818,684],4,0,240)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.logic([2016,432],0,0,280)
    {
    Type = "2"
    Inv = "0"
    }
   0.tbreakn([1818,468],4,0,70)
    {
    NUMS = "2"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   -Wire-([1872,324],0,0,-1)
    {
    Vertex="0,0;0,108"
    }
   -Wire-([1746,378],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.logic([2016,828],0,0,270)
    {
    Type = "2"
    Inv = "0"
    }
   0.import([1710,774],0,0,130)
    {
    Name = "Flt_en"
    }
   -Wire-([1746,378],0,0,-1)
    {
    Vertex="0,0;0,396"
    }
   -Wire-([1746,774],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.var([648,648],0,27926944,80)
    {
    Name = "Fault Start "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.var([648,684],0,27929928,90)
    {
    Name = "Duration "
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.21"
    Units = ""
    Collect = "1"
    }
   -Sticky-([36,918],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 36,918,162,1206
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source
          and  B1
  2=> FT2: 
          Between B1 
          and Line
  3=> FT3: 
          Between Line 1
          and B2
  4=> FT4: 
          Between Source
          and B2
  5=> FT5:
          Between B3
          and Line 2
  6=> FT6:
          Between Line 2 
          and B4  "
    }
   -Sticky-([180,900],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 180,900,288,1080
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> BC 
11=> No fault (0)"
    }
   -Sticky-([630,900],0)
    {
    Name = ""
    Font = 1
    Bounds = 630,900,918,1188
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Example of a Test  Sequence 

Fault is located on Line 2 at B3 (Fault location 5)
Fault is 3 phase to Ground (Fault Type 7)

Fault occurs at 0.30 sec,  Fault Duration 0.05 sec.

Set Breakers:
B1T1 =  2.00:  Breaker B1 does not trip
B2T1 =  2.00:  Breaker B2 does not trip
B3T1 =  0.35:  Breaker B3 trips in 35 msec
B4T1 =  0.40:  Breaker B4 trips in 40 msec
B1T2 =  2.00:  Breaker B1 does not reclose
B2T2 =  2.00:  Breaker B2 does not reclose
B3T2 =  2.00:  Breaker B3 does not reclose        
B4T2 =  2.00:  Breaker B4 does not reclose        

(Breaker  B1 and B2 do not operate automatically)
"
    }
   -Sticky-([1296,990],0)
    {
    Name = ""
    Font = 1
    Bounds = 1296,990,1422,1026
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   -Sticky-([1296,216],0)
    {
    Name = ""
    Font = 1
    Bounds = 1296,216,1440,252
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Sticky-([936,126],0)
    {
    Name = ""
    Font = 1
    Bounds = 936,126,1080,162
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "COMTRADE Recorders"
    }
   -ControlPanel-([864,342],0)
    {
    Name = "Recorder Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,288,126
    Switch(28397696)
    Switch(28400488)
    Switch(28403152)
    Switch(28405872)
    }
   -Sticky-([882,486],0)
    {
    Name = ""
    Font = 1
    Bounds = 882,486,1152,576
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
To turn the Recorders on, click on the switch.
On = Recorder will record data.
Off = Recorder will NOT record data.

You can turn on or off each recorder individually."
    }
   -Divider-([18,612],0)
    {
    Size(1224,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1242,36],0)
    {
    Size(0,1494)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([1242,954],0)
    {
    Size(1152,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   -Divider-([792,72],0)
    {
    Size(0,540)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 1144771850
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([2358,1206],0,27959440,1110)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([432,1116],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([468,1116],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([504,1116],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([432,1296],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([468,1296],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([504,1296],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1872,1170],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1890,1206],0,0,300)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1890,1242],0,0,400)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([324,1116],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([360,1116],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([396,1116],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([324,1296],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([360,1296],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([396,1296],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([2322,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2322,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2322,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2322,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2034,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2034,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2034,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2196,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([2016,1278],0,0,480)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2016,1242],0,0,440)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([2016,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2016,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2016,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1890,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1890,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1890,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1890,1278],0,0,460)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([2016,1206],0,0,320)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1998,1170],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1170,1098],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1080,1188],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([1116,1188],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([1152,1188],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([1134,1278],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([1080,1440],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1116,1440],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([1152,1440],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([1170,1350],2,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([2322,954],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([2034,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1908,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([360,702],0,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([360,720],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([1008,504],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([1008,522],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([1008,738],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([1008,756],0,0,-1)
    {
    Name = "F6"
    }
   0.datalabel([1206,1098],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1134,1098],2,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1224,1188],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([1260,1440],0,0,-1)
    {
    Name = "F6"
    }
   0.breaker3([1134,486],0,0,680)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "118.6 [MW]"
    Q = "-19.76 [MVAR]"
    }
   0.datalabel([576,504],0,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([576,522],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([810,666],0,0,-1)
    {
    Name = "FT5"
    }
   0.breaker3([450,486],4,0,690)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-116.6 [MW]"
    Q = "14.79 [MVAR]"
    }
   -Wire-([270,1404],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1350,1332],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([1350,1368],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([1350,1404],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1476,1332],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1476,1368],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1512,1332],0,28017400,1040)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "0.5"
    }
   0.pgb([1512,1368],0,28020232,980)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "0.5"
    }
   0.pgb([1386,1278],0,28023080,350)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1512,1206],0,28025992,220)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.datalabel([1638,1206],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1638,1242],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1638,1278],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([1674,1206],0,28031456,1170)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1764,1206],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1764,1242],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1800,1206],0,28035808,1160)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1800,1278],0,28038448,1080)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1638,1332],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1386,1242],0,28042120,250)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([1674,1242],0,28044896,1140)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1800,1242],0,28047672,1130)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1332,1206],0,0,180)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1332,1242],0,0,240)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1314,1170],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1350,1206],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1350,1242],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1476,1242],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([1512,1278],0,28055824,390)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   -Wire-([1638,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1638,1404],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1638,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1638,1440],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1764,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1764,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1764,1440],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1476,1206],2,0,-1)
    {
    Name = "V2A"
    }
   0.pgb([1800,1332],0,28064136,1000)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datalabel([1764,1404],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1764,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1764,1368],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1764,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1764,1332],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1764,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1764,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1764,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1764,1278],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1476,1404],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1476,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1476,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1476,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1350,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1350,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1350,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1332],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1638,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1476,1278],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1458,1278],0,0,370)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1458,1242],0,0,270)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1458,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1458,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1458,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1350,1278],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([1332,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1332,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1332,1206],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1332,1278],0,0,330)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1638,1368],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1674,1278],0,28086520,1100)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1458,1206],0,0,210)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1440,1170],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1440,1170],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1800,1368],0,28091456,920)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1674,1368],0,28094440,960)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1386,1332],0,28097352,1060)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "0.6"
    }
   0.pgb([1386,1404],0,28100152,940)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "0.6"
    }
   -Wire-([1476,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1350,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1386,1440],0,28103904,800)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.04"
    Max = "0.1"
    }
   0.datalabel([1476,1440],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1512,1440],0,28107880,780)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.06"
    }
   0.pgb([1512,1404],0,28110656,890)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "0.5"
    }
   0.pgb([1386,1368],0,28113568,1010)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "0.6"
    }
   -Wire-([1314,1170],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1350,1440],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1872,1170],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1908,1206],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1908,1242],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1908,1278],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([2034,1206],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([2034,1242],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([2034,1278],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([774,1116],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([810,1116],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([846,1116],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([774,1296],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([810,1296],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([846,1296],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1908,1332],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1908,1368],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1908,1404],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1908,1440],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([2034,1332],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([2034,1368],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([2034,1404],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([2034,1440],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([882,1116],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([918,1116],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([954,1116],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([882,1296],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([918,1296],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([954,1296],2,0,-1)
    {
    Name = "I4C"
    }
   0.recorder2_0([396,1188],0,0,1260)
    {
    FName = "stn1"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([2268,954],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([504,1260],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([504,1440],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2196,1332],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([2196,1368],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([2196,1206],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([2196,1242],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([2196,1278],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([2322,1206],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2322,1206],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([2322,1242],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([2322,1278],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([2322,1332],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([2322,1368],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1944,1206],0,28160448,310)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1944,1242],0,28163224,420)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1944,1278],0,28166304,470)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1944,1332],0,28169216,970)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.pgb([1944,1368],0,28172128,860)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.pgb([1944,1404],0,28175040,760)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.pgb([1944,1440],0,28177928,710)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "1.0"
    }
   0.pgb([2070,1206],0,28180840,340)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([2070,1242],0,28183928,450)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([2070,1332],0,28186840,950)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.pgb([2070,1368],0,28189752,810)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.pgb([2070,1404],0,28192840,730)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-3.0"
    Max = "4.0"
    }
   0.pgb([2070,1440],0,28195864,700)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.6"
    Max = "1.0"
    }
   0.pgb([2232,1206],0,28198776,1120)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2232,1242],0,28201552,1070)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2232,1278],0,28204328,1020)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2232,1368],0,28207104,770)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2358,1332],0,28210016,830)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([2358,1368],0,28212928,750)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2358,1242],0,28215840,1050)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2358,1278],0,28218616,990)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([810,684],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([1242,1098],2,0,-1)
    {
    Name = "B4"
    }
   0.breaker3([450,702],4,0,670)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.0424 [MW]"
    Q = "0.1947 [MVAR]"
    }
   0.pgb([1386,1206],0,28226040,190)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   0.pgb([2232,1422],0,28229008,520)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([2232,1458],0,28231920,530)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   -Wire-([414,594],0,0,-1)
    {
    Vertex="0,0;-144,0"
    }
   -Wire-([1170,594],0,0,-1)
    {
    Vertex="0,0;108,0"
    }
   0.datalabel([1206,720],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([1206,702],0,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1224,594],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1674,1332],0,28237776,1030)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([270,1224],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([2322,900],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.datalabel([2268,900],4,0,-1)
    {
    Name = "Breaker"
    }
   0.datalabel([1098,1116],0,0,-1)
    {
    Name = "Breaker"
    }
   0.var_pot([1062,1314],0,28243184,360)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "6"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([1134,1314],0,0,380)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([1998,1170],2,0,-1)
    {
    Name = "V4"
    }
   0.mux_array([1152,1386],6,0,610)
    {
    DPath = "0"
    }
   -Wire-([1224,1116],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.datatap([1134,1098],6,0,650)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1170,1098],6,0,640)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1206,1098],6,0,630)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1242,1098],6,0,620)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1080,1188],6,0,1240)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1116,1188],6,0,1230)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1152,1188],6,0,1220)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1188,1188],6,0,1210)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1224,1188],6,0,1200)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1260,1188],6,0,1190)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1188,1188],2,0,-1)
    {
    Name = "FT4"
    }
   -Wire-([1242,1206],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datatap([1080,1440],0,0,930)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1116,1440],0,0,910)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1152,1440],0,0,900)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1188,1440],0,0,870)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1224,1440],0,0,850)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1260,1440],0,0,840)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1260,1188],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([1224,1440],0,0,-1)
    {
    Name = "F5"
    }
   -Wire-([1242,1422],0,0,-1)
    {
    Vertex="0,0;-180,0"
    }
   0.datalabel([1188,1440],0,0,-1)
    {
    Name = "F4"
    }
   0.datalabel([2268,918],4,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([2268,918],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.breaker3([1134,702],0,0,660)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.07405 [MW]"
    Q = "0.1859 [MVAR]"
    }
   0.var_pot([1242,1314],2,28275256,430)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "11"
    Value = "4"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([1170,1314],4,0,590)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([1170,1314],1,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([1170,1278],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.pgb([2232,1332],0,28280296,880)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([342,594],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([252,666],3,28283712,60)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "0.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([198,666],3,28286696,50)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.var([1350,666],5,28289552,90)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   0.source3R([234,594],6,0,560)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(freq)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.source3R([1314,594],2,0,570)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(freq)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "52.9 [ohm]"
    Phi1 = "80.0 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "52.9 [ohm]"
    Phi0 = "80.0 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   0.var([1296,666],3,28296336,80)
    {
    Name = "Phase-S2"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "20.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([1026,702],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.tpflt([324,684],0,0,1300)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([540,486],0,0,1320)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1044,720],4,0,1270)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1044,486],4,0,1310)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1242,684],4,0,1280)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([1152,1494],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([1224,1494],0,0,-1)
    {
    Name = "Ron"
    }
   -Wire-([648,630],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([522,702],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   -Wire-([648,486],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([522,486],0,0,-1)
    {
    Vertex="0,0;126,0"
    }
   0.breakout2([900,594],0,0,-1)
    {
    }
   -Wire-([936,486],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([1062,486],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   -Wire-([936,630],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Wire-([1062,702],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.pgb([2232,1530],0,28313072,550)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([2232,1494],0,28315928,540)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.annotation([1098,1476],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.recorder2_0([846,1368],0,0,1090)
    {
    FName = "stn4"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.datalabel([954,1440],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([954,1260],0,0,-1)
    {
    Name = "Fault"
    }
   0.pgb([1674,1404],0,28332400,820)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1674,1440],0,28335424,740)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1800,1404],0,28338336,790)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1800,1440],0,28341248,720)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   -Bus-([1170,468],0,24172880,-1)
    {
    P1 = [0,0]
    P2 = [0,252]
    I = 1
    NAME = BUS2
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Bus-([414,468],0,24174600,-1)
    {
    P1 = [0,0]
    P2 = [0,252]
    I = 1
    NAME = BUS1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Sticky-([54,54],0)
    {
    Name = ""
    Font = 1
    Bounds = 54,54,594,252
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
Description: 
- Two Thevinen Impedance sources connected via two parallel 100km  transmission lines on the same tower.
- System voltage is 230kV settable via source equivalents.
- Simulates two substations connected via two transmission lines.
- Six fault positions for full fault control ahead and behind station relays.
- Four breakers are independently timed controlled. (Default is closed).
- Independent breaker pole tripping is possible.

Global Substitution  \"freq =  60.0 [Hz]\"  is  used in this  example"
    }
   0.const([144,1152],1,0,120)
    {
    Name = ""
    Value = "10.0"
    }
   0.pgb([2070,1278],0,28348584,490)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1512,1242],0,28351552,290)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-250.0"
    Max = "250.0"
    }
   -Sticky-([1278,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 1278,1116,1404,1152
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.mux_array([1152,1242],0,0,1180)
    {
    DPath = "0"
    }
   0.var([1116,1494],0,28356000,510)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.recorder2_0([846,1188],0,0,1250)
    {
    FName = "stn3"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([396,1368],0,0,1150)
    {
    FName = "stn2"
    FFMT = "2"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.var([108,1512],0,28380888,500)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   -Wire-([702,1512],0,0,-1)
    {
    Vertex="0,0;-558,0"
    }
   0.const([144,1332],1,0,200)
    {
    Name = ""
    Value = "10.0"
    }
   0.select([180,1368],6,0,260)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.select([180,1188],6,0,580)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   0.const([612,1152],1,0,140)
    {
    Name = ""
    Value = "10.0"
    }
   -Wire-([216,1188],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -Wire-([594,1494],0,0,-1)
    {
    Vertex="0,0;-504,0"
    }
   -Wire-([612,1224],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   -Wire-([144,1224],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([144,1404],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Wire-([90,1224],0,0,-1)
    {
    Vertex="0,0;0,270"
    }
   0.var([54,1224],0,28390464,150)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   -Wire-([216,1368],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.select([648,1368],6,0,410)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([612,1404],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.const([612,1332],1,0,280)
    {
    Name = ""
    Value = "10.0"
    }
   -Wire-([684,1368],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.select([648,1188],6,0,160)
    {
    A = "1"
    DPath = "1"
    COM = "Selector"
    }
   -Wire-([594,1224],0,0,-1)
    {
    Vertex="0,0;0,270"
    }
   0.var_switch([180,1116],1,28397696,110)
    {
    Name = "en Record1"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([180,1296],1,28400488,170)
    {
    Name = "en Record2"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([648,1116],1,28403152,130)
    {
    Name = "en Record3"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_switch([648,1296],1,28405872,230)
    {
    Name = "en Record4"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   -Wire-([702,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([702,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([684,1188],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([702,1224],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([270,1224],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Sticky-([1278,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 1278,666,1368,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   -Sticky-([180,666],0)
    {
    Name = ""
    Font = 1
    Bounds = 180,666,270,702
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   .Controls([2358,936],4,0,600)
    {
    }
   0.breakout2([684,594],4,0,-1)
    {
    }
   .Plots_B2([1116,360],0,0,20)
    {
    }
   -Wire-([792,630],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.breakout2([828,594],4,0,-1)
    {
    }
   -TLine-([684,594],0,24370072,-1)
    {
    Name = "L1_2"
    Date = 1144771851
    Freq = "$(freq)"
    Length = "50 [km]"
    Dim = 6
    Mode = 1
    Vertex="0,0;18,0;18,0;36,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FrePhase_Options([252,450],0,24384376,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.Line_Ground([666,666],0,24385768,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_Tower_6_Concent([792,540],0,24386256,-1)
      {
      TName = "3L12"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X2 = "2 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "15 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NC4 = "4"
      NC5 = "5"
      NC6 = "6"
      NG1 = "7"
      NG2 = "8"
      }
     }
    }
   -TLine-([828,594],0,24232344,-1)
    {
    Name = "L1_1"
    Date = 1144771852
    Freq = "$(freq)"
    Length = "50 [km]"
    Dim = 6
    Mode = 1
    Vertex="0,0;18,0;54,0;72,0"
    PageLayer(A/A4,Landscape,16,[597,467],100)
     {
     0.Line_FrePhase_Options([252,450],0,24233560,-1)
      {
      Interp1 = "1"
      Output = "0"
      Inflen = "0"
      FS = "0.5 [Hz]"
      FE = "1.0E6 [Hz]"
      Numf = "100"
      YMaxP = "20"
      AMaxP = "20"
      YMaxE = "2 [%]"
      AMaxE = "2 [%]"
      xxx = ""
      W1 = "100"
      W2 = "1000"
      W3 = "1"
      }
     0.Line_Ground([666,666],0,24234768,-1)
      {
      GRRES = "100.0 [ohm*m]"
      GPERM = "1.0"
      EarthForm = "0"
      }
     0.Line_Tower_6_Concent([792,540],0,24235256,-1)
      {
      TName = "3L12"
      Y = "30 [m]"
      Y2 = "5 [m]"
      XC = "10 [m]"
      X2 = "2 [m]"
      X = "0 [m]"
      ShuntG = "1.0E-10 [mho/m]"
      SHSag = "0"
      Transp = "1"
      NG = "2"
      ElimGW = "1"
      CDataType = "1"
      CName = "chukar"
      CLName = "..conductor.clb"
      RadiusC = "0.0203454 [m]"
      DCResC = "0.03206 [ohm/km]"
      SAGC = "10 [m]"
      NCondB = "1"
      BundSym = "0"
      SHBund = "1"
      BSP = ".4572 [m]"
      GDataType = "1"
      GName = "1/2\"HighStrengthSteel"
      GLName = "..\\conductor.clb"
      RadiusG = "0.0055245 [m]"
      DCResG = "2.8645 [ohm/km]"
      SAGG = "10 [m]"
      YG = "15 [m]"
      XG = "10 [m]"
      XB1 = "-0.1 [m]"
      YB1 = "0.1 [m]"
      XB2 = "-0.1 [m]"
      YB2 = "0.1 [m]"
      XB3 = "-0.1 [m]"
      YB3 = "0.1 [m]"
      XB4 = "-0.1 [m]"
      YB4 = "0.1 [m]"
      XB5 = "-0.1 [m]"
      YB5 = "0.1 [m]"
      XB6 = "-0.1 [m]"
      YB6 = "0.1 [m]"
      XB7 = "-0.1 [m]"
      YB7 = "0.1 [m]"
      XB8 = "-0.1 [m]"
      YB8 = "0.1 [m]"
      XB9 = "-0.1 [m]"
      YB9 = "0.1 [m]"
      XB10 = "-0.1 [m]"
      YB10 = "0.1 [m]"
      NC1 = "1"
      NC2 = "2"
      NC3 = "3"
      NC4 = "4"
      NC5 = "5"
      NC6 = "6"
      NG1 = "7"
      NG2 = "8"
      }
     }
    }
   .Plots_B1([450,360],0,0,10)
    {
    }
   -Wire-([756,558],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.breakout2([720,594],0,0,-1)
    {
    }
   -Wire-([756,630],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.tpflt([774,648],0,0,1290)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Divider-([36,1026],0)
    {
    Size(2358,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.multimeter([504,486],0,0,30)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([504,702],0,0,70)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([1080,486],4,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([1080,702],4,0,100)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([2196,1422],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2196,1422],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([2196,1458],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2196,1458],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([2196,1494],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2196,1494],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([2196,1530],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2196,1530],0,0,-1)
    {
    Name = "V4rms"
    }
   }
  }
 }

